/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.F.C;
import com.ubnt.data.X;
import com.ubnt.service.analytics.H;
import com.ubnt.service.trace.api.client.ClientUplink;
import com.ubnt.service.trace.api.client.ImmutableClientStats;
import com.ubnt.service.trace.api.client.WirelessStats;
import jakarta.annotation.Nullable;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableClientStats.class)
@JsonDeserialize(as=ImmutableClientStats.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Value.Immutable
@C
public abstract class ClientStats {
    private static final String MANUFACTURER_UNKNOWN = "Unknown";
    private static final int MISSING_ENGINE_VALUE = -1;

    @JsonProperty(value="isWired")
    public abstract boolean isWired();

    @Nullable
    @JsonProperty(value="anonymousSiteId")
    public abstract String getAnonymousSiteId();

    @Nullable
    @JsonProperty(value="anonymousClientId")
    public abstract String getAnonymousClientId();

    @JsonProperty(value="oui")
    public abstract String getOui();

    @JsonProperty(value="fingerprintEngine")
    public abstract int getFingerprintEngine();

    @Nullable
    @JsonProperty(value="devCat")
    public abstract Integer getDevCat();

    @Nullable
    @JsonProperty(value="devFamily")
    public abstract Integer getDevFamily();

    @Nullable
    @JsonProperty(value="devId")
    public abstract Integer getDevId();

    @Nullable
    @JsonProperty(value="devVendor")
    public abstract Integer getDevVendor();

    @Nullable
    @JsonProperty(value="osClass")
    public abstract Integer getOsClass();

    @Nullable
    @JsonProperty(value="osName")
    public abstract Integer getOsName();

    @Nullable
    @JsonProperty(value="satisfaction")
    public abstract Integer getSatisfaction();

    @Nullable
    @JsonProperty(value="wirelessStats")
    public abstract WirelessStats getWirelessStats();

    @Nullable
    @JsonProperty(value="uplink")
    public abstract ClientUplink getUplink();

    public static ImmutableClientStats.Builder builder() {
        return ImmutableClientStats.builder();
    }

    public static ImmutableClientStats.Builder buildFrom(X x2) {
        return ClientStats.builder().anonymousClientId(ClientStats.o00000(x2)).isWired(x2.getBoolean("is_wired")).oui(x2.getString("oui", MANUFACTURER_UNKNOWN)).fingerprintEngine(x2.getInt("fingerprint_source", -1)).devCat(x2.getIntOrNull("dev_cat")).devFamily(x2.getIntOrNull("dev_family")).devId(x2.getIntOrNull("dev_id")).devVendor(x2.getIntOrNull("dev_vendor")).osClass(x2.getIntOrNull("os_class")).osName(x2.getIntOrNull("os_name")).satisfaction(x2.getIntOrNull("satisfaction"));
    }

    private static String o00000(X x2) {
        return x2.getOptionalString("anon_client_id").orElse(ClientStats.\u00d200000(x2));
    }

    private static String \u00d200000(X x2) {
        String string = x2.getString("network_id");
        String string2 = x2.getString("mac");
        if (string == null || string2 == null) {
            return null;
        }
        return H.new(string, string2).toString();
    }
}

