/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.eap;

import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.auth.eap.ClientLayer;
import com.axlradius.radclient4.auth.eap.EAPParameters;
import com.axlradius.radclient4.auth.eap.EAPType;
import com.axlradius.radclient4.auth.eap.Entity;
import com.axlradius.radclient4.auth.eap.PublicState;
import com.axlradius.radclient4.auth.eap.tls.TLSClientParameters;
import com.axlradius.radclient4.auth.mschap.MSChap;
import com.axlradius.radclient4.radutil.Util;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EAPClientParameters
implements EAPParameters {
    public static final MSChap.PasswordType PLAINTEXT = MSChap.PasswordType.PLAINTEXT;
    public static final MSChap.PasswordType NTHASH = MSChap.PasswordType.NTHASH;
    private AttributeList c;
    private byte[] p;
    private byte[] q;
    private byte[] r;
    private byte[] s;
    private MSChap.PasswordType a;
    private ClientLayer a;
    private EAPType b;
    private boolean i = false;
    private boolean j = false;
    private TLSClientParameters a;
    private PublicState a = PublicState.NONE;

    public EAPClientParameters(byte[] byArray, AttributeList attributeList) throws IllegalArgumentException {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("User-Name cannot be empty.");
        }
        this.r = byArray;
        this.p = this.stripRealm(byArray);
        this.q = this.p;
        this.c = attributeList.copy();
        this.b = new EAPType(0);
    }

    public EAPClientParameters(byte[] byArray, byte[] byArray2, AttributeList attributeList) throws IllegalArgumentException {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("User-Name cannot be empty.");
        }
        this.r = byArray;
        this.p = this.stripRealm(byArray);
        if (byArray2 == null || byArray2.length == 0) {
            throw new IllegalArgumentException("Inner Identity value cannot be empty.");
        }
        this.q = this.stripRealm(byArray2);
        if (attributeList == null || attributeList.size() == 0) {
            throw new IllegalArgumentException("Accept Attribute list cannot be empty.");
        }
        this.c = attributeList.copy();
    }

    public final void setPassword(byte[] byArray, MSChap.PasswordType passwordType) {
        this.s = byArray;
        this.a = passwordType;
    }

    public final MSChap.PasswordType getPasswordType() {
        return this.a;
    }

    public final byte[] getPassword() {
        return this.s;
    }

    public void setTLSParameters(TLSClientParameters tLSClientParameters) {
        this.a = tLSClientParameters;
    }

    public TLSClientParameters getTLSParameters() {
        return this.a;
    }

    @Override
    public EAPType getEAPType() {
        return this.b;
    }

    @Override
    public Entity getEntity() {
        return Entity.Client;
    }

    @Override
    public void setEAPType(EAPType eAPType) {
        this.b = eAPType;
    }

    public byte[] getUserName() {
        return this.r;
    }

    public byte[] getOuterIdentity() {
        return this.p;
    }

    public byte[] getAuthenticationName() {
        return this.q;
    }

    public void setInnerSuccess(boolean bl) {
        this.i = bl;
    }

    public boolean isInnerSuccess() {
        return this.i;
    }

    public void setOuterSuccess(boolean bl) {
        this.j = bl;
    }

    public boolean isOuterSuccess() {
        return this.j;
    }

    public AttributeList getCommonList() {
        return this.c;
    }

    public void close() {
        this.clean();
    }

    public void clean() {
        Util.clean(this.r);
        Util.clean(this.p);
        Util.clean(this.q);
        Util.clean(this.s);
        this.b = EAPType.TYPE.UNDEFINED.getType();
        this.i = false;
        this.j = false;
        if (this.a != null) {
            this.a.clean();
        }
        this.c.clean();
    }

    public byte[] stripRealm(byte[] byArray) {
        int n2;
        if (byArray == null) {
            return byArray;
        }
        int n3 = n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != 64) continue;
            n3 = i2;
            break;
        }
        byte[] byArray2 = new byte[n3];
        if (n3 > 0) {
            System.arraycopy(byArray, 0, byArray2, 0, n3);
        }
        return byArray2;
    }

    public void setClientLayer(ClientLayer clientLayer) {
        this.a = clientLayer;
    }

    public ClientLayer getClientLayer() {
        return this.a;
    }

    public void setPublicState(PublicState publicState) {
        this.a = publicState;
    }

    public PublicState getPublicState() {
        return this.a;
    }
}

