/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import io.jenetics.internal.math.random;
import io.jenetics.internal.util.require;
import io.jenetics.util.RandomRegistry;

public final class bit {
    private static final byte[] BIT_SET_TABLE = new byte[]{1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7};
    private static final int BIT_SET_TABLE_INDEX_OFFSET = 128;

    private bit() {
        require.noInstance();
    }

    public static boolean get(byte[] data, int index) {
        return (data[index >>> 3] & 1 << (index & 7)) != 0;
    }

    public static byte[] set(byte[] data, int index, boolean value) {
        return value ? bit.set(data, index) : bit.unset(data, index);
    }

    public static byte[] set(byte[] data, int index) {
        int n = index >>> 3;
        data[n] = (byte)(data[n] | 1 << (index & 7));
        return data;
    }

    public static byte[] unset(byte[] data, int index) {
        int n = index >>> 3;
        data[n] = (byte)(data[n] & ~(1 << (index & 7)));
        return data;
    }

    public static void swap(byte[] data, int start, int end, byte[] otherData, int otherStart) {
        int i = end - start;
        while (--i >= 0) {
            boolean temp = bit.get(data, i + start);
            bit.set(data, i + start, bit.get(otherData, otherStart + i));
            bit.set(otherData, otherStart + i, temp);
        }
    }

    public static int count(byte[] data) {
        int count = 0;
        int i = data.length;
        while (--i >= 0) {
            count += bit.count(data[i]);
        }
        return count;
    }

    public static int count(byte value) {
        return BIT_SET_TABLE[value + 128];
    }

    public static byte[] shiftRight(byte[] data, int shift) {
        int bytes = Math.min(shift >>> 3, data.length);
        int bits = shift & 7;
        if (bytes > 0) {
            int i;
            int n = data.length - bytes;
            for (i = 0; i < n; ++i) {
                data[i] = data[i + bytes];
            }
            i = data.length;
            n = data.length - bytes;
            while (--i >= n) {
                data[i] = 0;
            }
        }
        if (bits > 0 && bytes < data.length) {
            int carry = 0;
            int nextCarry = 0;
            int i = data.length;
            while (--i >= 0) {
                int d = data[i] & 0xFF;
                nextCarry = d << 8 - bits;
                d >>>= bits;
                data[i] = (byte)((d |= carry) & 0xFF);
                carry = nextCarry;
            }
        }
        return data;
    }

    public static byte[] shiftLeft(byte[] data, int shift) {
        int bytes = Math.min(shift >>> 3, data.length);
        int bits = shift & 7;
        if (bytes > 0) {
            int i;
            int n = data.length - bytes;
            for (i = 0; i < n; ++i) {
                data[data.length - 1 - i] = data[data.length - 1 - i - bytes];
            }
            for (i = 0; i < bytes; ++i) {
                data[i] = 0;
            }
        }
        if (bits > 0 && bytes < data.length) {
            int carry = 0;
            int nextCarry = 0;
            for (int i = bytes; i < data.length; ++i) {
                int d = data[i] & 0xFF;
                nextCarry = d >>> 8 - bits;
                d <<= bits;
                data[i] = (byte)((d |= carry) & 0xFF);
                carry = nextCarry;
            }
        }
        return data;
    }

    public static byte[] increment(byte[] data) {
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = (byte)(data[n] + 1);
            if (data[n] == 0) continue;
        }
        return data;
    }

    public static byte[] invert(byte[] data) {
        int i = data.length;
        while (--i >= 0) {
            data[i] = ~data[i];
        }
        return data;
    }

    public static byte[] complement(byte[] data) {
        return bit.increment(bit.invert(data));
    }

    public static byte[] flip(byte[] data, int index) {
        return bit.get(data, index) ? bit.unset(data, index) : bit.set(data, index);
    }

    public static byte[] reverse(byte[] array2) {
        int i = 0;
        int j = array2.length;
        while (i < j) {
            bit.swap(array2, i++, --j);
        }
        return array2;
    }

    private static void swap(byte[] array2, int i, int j) {
        byte temp = array2[i];
        array2[i] = array2[j];
        array2[j] = temp;
    }

    public static byte[] copy(byte[] data, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException(String.format("start > end: %d > %d", start, end));
        }
        if (start < 0 || start > data.length << 3) {
            throw new ArrayIndexOutOfBoundsException(String.format("%d < 0 || %d > %d", start, start, data.length * 8));
        }
        int to = Math.min(data.length << 3, end);
        int byteStart = start >>> 3;
        int bitStart = start & 7;
        int bitLength = to - start;
        byte[] copy = new byte[bit.toByteLength(to - start)];
        if (copy.length > 0) {
            System.arraycopy(data, byteStart, copy, 0, copy.length);
            bit.shiftRight(copy, bitStart);
            if (data.length > copy.length + byteStart) {
                int n = copy.length - 1;
                copy[n] = (byte)(copy[n] | (byte)(data[byteStart + copy.length] << 8 - bitStart));
            }
            int n = copy.length - 1;
            copy[n] = (byte)(copy[n] & 255 >>> (copy.length << 3) - bitLength);
        }
        return copy;
    }

    public static boolean getAndSet(byte[] array2, int index) {
        boolean result = bit.get(array2, index);
        bit.set(array2, index);
        return result;
    }

    public static String toByteString(byte ... data) {
        StringBuilder out = new StringBuilder();
        if (data.length > 0) {
            for (int j = 7; j >= 0; --j) {
                out.append(data[data.length - 1] >>> j & 1);
            }
        }
        for (int i = data.length - 2; i >= 0; --i) {
            out.append('|');
            for (int j = 7; j >= 0; --j) {
                out.append(data[i] >>> j & 1);
            }
        }
        return out.toString();
    }

    public static byte[] fromByteString(String data) {
        String[] parts = data.split("\\|");
        byte[] bytes = new byte[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].length() != 8) {
                throw new IllegalArgumentException("Byte value doesn't contain 8 bit: " + parts[i]);
            }
            try {
                bytes[parts.length - 1 - i] = (byte)Integer.parseInt(parts[i], 2);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return bytes;
    }

    public static byte[] newArray(int length) {
        return new byte[bit.toByteLength(length)];
    }

    public static byte[] newArray(int length, double p) {
        byte[] bytes = bit.newArray(length);
        random.indexes(RandomRegistry.getRandom(), length, p).forEach(i -> {
            int n = i >>> 3;
            bytes[n] = (byte)(bytes[n] | 1 << (i & 7));
        });
        return bytes;
    }

    public static int toByteLength(int bitLength) {
        return (bitLength & 7) == 0 ? bitLength >>> 3 : (bitLength >>> 3) + 1;
    }

    public static int toInt(byte[] data) {
        return ((data[0] & 0xFF) << 24) + ((data[1] & 0xFF) << 16) + ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
    }

    public static byte[] toBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }

    public static long toLong(byte[] data) {
        return ((long)data[0] << 56) + ((long)(data[1] & 0xFF) << 48) + ((long)(data[2] & 0xFF) << 40) + ((long)(data[3] & 0xFF) << 32) + ((long)(data[4] & 0xFF) << 24) + (long)((data[5] & 0xFF) << 16) + (long)((data[6] & 0xFF) << 8) + (long)(data[7] & 0xFF);
    }

    public static byte[] toBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }
}

