/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.device;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.data.DeviceType;
import com.ubnt.model.api.SearchTag;
import com.ubnt.model.api.device.DeviceIconInfoDto;
import com.ubnt.model.api.device.ImmutableClientDeviceDto;
import com.ubnt.model.api.device.UnifiDeviceDto;
import com.ubnt.model.api.device.UplinkDto;
import com.ubnt.model.api.device.UpsDeviceDto;
import com.ubnt.model.for.B;
import com.ubnt.model.for.OOOo;
import com.ubnt.model.for.for;
import com.ubnt.model.for.super.C;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableClientDeviceDto.class)
@Value.Immutable
@com.ubnt.OOoO.Object
public abstract class ClientDeviceDto
implements UnifiDeviceDto {
    @JsonProperty(value="type")
    public abstract Optional<DeviceType> type();

    @JsonProperty(value="icon_resolutions")
    public abstract List<List<Integer>> iconResolutions();

    @JsonProperty(value="icon_filename")
    public abstract String iconFilename();

    @JsonProperty(value="icons")
    public abstract List<DeviceIconInfoDto> icons();

    @Override
    public abstract int state();

    @Override
    public for unifiDeviceType() {
        return for.Object;
    }

    @JsonProperty(value="is_wired")
    public abstract boolean isWired();

    @JsonProperty(value="wired_speed_megabits_per_second")
    public abstract Optional<Integer> wiredSpeedMegabitsPerSecond();

    @JsonProperty(value="firmware_status")
    public abstract Optional<OOOo> firmwareStatus();

    @JsonProperty(value="essid")
    public abstract Optional<String> essid();

    @JsonProperty(value="rate_imbalance")
    @Schema(description="Imbalance in percent between rate of the client and its uplink. Possible values [-100;100]. 0 indicates perfect balance, negative values - higher client rate. Since 7.3.26", example="-40")
    public abstract Optional<Integer> rateImbalance();

    @JsonProperty(value="uplink_mac")
    public abstract String uplinkMac();

    @JsonProperty(value="last_uplink")
    public abstract Optional<UplinkDto> lastUplink();

    @JsonProperty(value="uplink_radio_band")
    public abstract Optional<C> uplinkRadioBand();

    @JsonProperty(value="view_in_application")
    public abstract boolean viewInApplication();

    @JsonProperty(value="tags")
    public abstract Set<SearchTag> tags();

    public static ImmutableClientDeviceDto.Builder builder() {
        return ImmutableClientDeviceDto.builder();
    }

    public static ClientDeviceDto of(B b2) {
        return ClientDeviceDto.of(b2, null);
    }

    public static ClientDeviceDto of(B b2, @Nullable DeviceType deviceType) {
        return ClientDeviceDto.builder().id(b2.\u00d6O0000()).mac(b2.\u00d500000()).type(Optional.ofNullable(deviceType)).name(b2.oO0000()).state(b2.\u00f8O0000()).isDefault(b2.\u00d200000()).modelShortname(b2.\u00d800000()).ipAddress(b2.oo0000()).experience(b2.\u00f5O0000()).version(b2.String()).displayableVersion(b2.\u00d3O0000()).firmwareStatus(b2.\u00d20O000()).usageBytes(b2.returnsuper()).downloadSpeedBytesPerSecond(b2.private()).uploadSpeedBytesPerSecond(b2.newsuper()).uptimeSeconds(b2.\u00d600000()).iconFilename(b2.\u00f8\u00f60000()).iconResolutions(b2.\u00f60O000()).icons(ClientDeviceDto.\u00d3\u00d80000(b2)).productLine(b2.\u00f500000()).isWired(b2.\u00d5\u00f80000()).wiredSpeedMegabitsPerSecond(b2.\u00f8\u00f80000()).lastSeenTimestampSeconds(b2.\u00f600000()).essid(b2.nullnull()).rateImbalance(b2.\u00f80O000()).connectionNetworkId(b2.\u00d8O0000()).connectionNetworkName(b2.\u00d300000()).uplinkMac(b2.\u00d8\u00f80000()).lastUplink(UplinkDto.of(b2.\u00d2O0000())).ipv4ActiveLeaseExpirationTimestampSeconds(b2.\u00d2o0000()).lastConnectionNetworkId(b2.for()).lastConnectionNetworkName(b2.\u00f6O0000()).uplinkRadioBand(b2.\u00d3\u00f80000()).viewInApplication(b2.newint()).tags(b2.\u00d8\u00f60000()).upsDevice(b2.null().map(UpsDeviceDto::of)).gracefulShutdownTriggeredByPairedUpsAt(b2.\u00f800000()).build();
    }

    private static List<DeviceIconInfoDto> \u00d3\u00d80000(B b2) {
        return b2.Stringnull().stream().map(DeviceIconInfoDto::of).collect(Collectors.toList());
    }
}

