/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.Selector;
import io.jenetics.TournamentSelector;
import io.jenetics.TruncationSelector;
import io.jenetics.internal.util.require;
import io.jenetics.util.ISeq;
import io.jenetics.util.Seq;
import java.util.Objects;

public class EliteSelector<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Selector<G, C> {
    private final TruncationSelector<G, C> ELITE_SELECTOR = new TruncationSelector();
    private final Selector<G, C> _nonEliteSelector;
    private final int _eliteCount;

    public EliteSelector(int eliteCount, Selector<G, C> nonEliteSelector) {
        this._eliteCount = require.positive(eliteCount);
        this._nonEliteSelector = Objects.requireNonNull(nonEliteSelector);
    }

    public EliteSelector(int eliteCount) {
        this(eliteCount, new TournamentSelector(3));
    }

    public EliteSelector(Selector<G, C> nonEliteSelector) {
        this(1, nonEliteSelector);
    }

    public EliteSelector() {
        this(1, new TournamentSelector(3));
    }

    @Override
    public ISeq<Phenotype<G, C>> select(Seq<Phenotype<G, C>> population, int count, Optimize opt) {
        Seq<Phenotype<G, C>> result;
        if (count < 0) {
            throw new IllegalArgumentException(String.format("Selection count must be greater or equal then zero, but was %s.", count));
        }
        if (population.isEmpty() || count <= 0) {
            result = ISeq.empty();
        } else {
            int ec = Math.min(count, this._eliteCount);
            result = this.ELITE_SELECTOR.select(population, ec, opt);
            result = result.append(this._nonEliteSelector.select(population, Math.max(0, count - ec), opt));
        }
        return result;
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * this._eliteCount + 37;
        return hash += 31 * Objects.hashCode(this._nonEliteSelector) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof EliteSelector && ((EliteSelector)obj)._eliteCount == this._eliteCount && ((EliteSelector)obj)._nonEliteSelector.equals(this._nonEliteSelector);
    }

    public String toString() {
        return String.format("EliteSelector[%d, %s]", this._eliteCount, this._nonEliteSelector);
    }
}

