/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.math;

import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import java.util.Objects;

public final class DoubleAdder
extends Number
implements Comparable<DoubleAdder> {
    private static final long serialVersionUID = 1L;
    private double _sum = 0.0;
    private double _simpleSum = 0.0;
    private double _compensation = 0.0;

    public DoubleAdder(double value) {
        this.add(value);
    }

    public DoubleAdder() {
    }

    private DoubleAdder reset() {
        this._sum = 0.0;
        this._simpleSum = 0.0;
        this._compensation = 0.0;
        return this;
    }

    public DoubleAdder set(double value) {
        return this.reset().add(value);
    }

    public DoubleAdder set(DoubleAdder value) {
        return this.reset().add(Objects.requireNonNull(value));
    }

    public DoubleAdder add(double value) {
        this.addWithCompensation(value);
        this._simpleSum += value;
        return this;
    }

    public DoubleAdder add(double[] values) {
        int i = values.length;
        while (--i >= 0) {
            this.add(values[i]);
        }
        return this;
    }

    private void addWithCompensation(double value) {
        double y = value - this._compensation;
        double t = this._sum + y;
        this._compensation = t - this._sum - y;
        this._sum = t;
    }

    public DoubleAdder add(DoubleAdder value) {
        this.addWithCompensation(value._sum);
        this.addWithCompensation(value._compensation);
        this._simpleSum += value._simpleSum;
        return this;
    }

    public DoubleAdder combine(DoubleAdder other) {
        return this.add(other);
    }

    public double value() {
        double result = this._sum + this._compensation;
        return Double.isNaN(result) && Double.isInfinite(this._simpleSum) ? this._simpleSum : result;
    }

    @Override
    public int intValue() {
        return (int)this.value();
    }

    @Override
    public long longValue() {
        return (long)this.value();
    }

    @Override
    public float floatValue() {
        return (float)this.value();
    }

    @Override
    public double doubleValue() {
        return this.value();
    }

    @Override
    public int compareTo(DoubleAdder other) {
        return Double.compare(this.doubleValue(), other.doubleValue());
    }

    public boolean sameState(DoubleAdder other) {
        return Double.compare(this._sum, other._sum) == 0 && Double.compare(this._simpleSum, other._simpleSum) == 0 && Double.compare(this._compensation, other._compensation) == 0;
    }

    public int hashCode() {
        return Hash.of(DoubleAdder.class).and(this.doubleValue()).value();
    }

    public boolean equals(Object obj) {
        return obj instanceof DoubleAdder && Equality.eq(this.doubleValue(), ((DoubleAdder)obj).doubleValue());
    }

    public String toString() {
        return Double.toString(this.doubleValue());
    }

    public static double sum(double[] values) {
        return new DoubleAdder().add(values).doubleValue();
    }
}

