/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BaseShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BellmanFordIterator;
import org.jgrapht.alg.shortestpath.BellmanFordPathElement;
import org.jgrapht.graph.GraphWalk;

public class BellmanFordShortestPath<V, E>
extends BaseShortestPathAlgorithm<V, E> {
    private static final double DEFAULT_EPSILON = 1.0E-9;
    protected V startVertex;
    protected int nMaxHops;
    protected double epsilon;

    public BellmanFordShortestPath(Graph<V, E> graph) {
        this(graph, graph.vertexSet().size() - 1);
    }

    public BellmanFordShortestPath(Graph<V, E> graph, int nMaxHops) {
        this(graph, nMaxHops, 1.0E-9);
    }

    public BellmanFordShortestPath(Graph<V, E> graph, int nMaxHops, double epsilon) {
        super(graph);
        this.nMaxHops = nMaxHops;
        this.epsilon = epsilon;
    }

    @Override
    public GraphPath<V, E> getPath(V source, V sink) {
        if (!this.graph.containsVertex(sink)) {
            throw new IllegalArgumentException("Graph must contain the sink vertex!");
        }
        return this.getPaths(source).getPath(sink);
    }

    @Override
    public ShortestPathAlgorithm.SingleSourcePaths<V, E> getPaths(V source) {
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        BellmanFordIterator iter = new BellmanFordIterator(this.graph, source, this.epsilon);
        for (int passNumber = 1; passNumber <= this.nMaxHops && iter.hasNext(); ++passNumber) {
            iter.next();
        }
        return new PathElementSingleSourcePaths(iter);
    }

    public static <V, E> GraphPath<V, E> findPathBetween(Graph<V, E> graph, V source, V sink) {
        return new BellmanFordShortestPath<V, E>(graph).getPath(source, sink);
    }

    private class PathElementSingleSourcePaths
    implements ShortestPathAlgorithm.SingleSourcePaths<V, E> {
        private BellmanFordIterator<V, E> it;

        PathElementSingleSourcePaths(BellmanFordIterator<V, E> it) {
            this.it = it;
        }

        @Override
        public Graph<V, E> getGraph() {
            return this.it.graph;
        }

        @Override
        public V getSourceVertex() {
            return this.it.startVertex;
        }

        @Override
        public double getWeight(V targetVertex) {
            if (targetVertex.equals(this.it.startVertex)) {
                return 0.0;
            }
            BellmanFordPathElement pathElement = this.it.getPathElement(targetVertex);
            if (pathElement == null) {
                return Double.POSITIVE_INFINITY;
            }
            return pathElement.getCost();
        }

        @Override
        public GraphPath<V, E> getPath(V targetVertex) {
            if (targetVertex.equals(this.it.startVertex)) {
                return BellmanFordShortestPath.this.createEmptyPath(this.it.startVertex, targetVertex);
            }
            BellmanFordPathElement pathElement = this.it.getPathElement(targetVertex);
            if (pathElement == null) {
                return BellmanFordShortestPath.this.createEmptyPath(this.it.startVertex, targetVertex);
            }
            return new GraphWalk(BellmanFordShortestPath.this.graph, this.it.startVertex, targetVertex, null, pathElement.createEdgeListPath(), pathElement.getCost());
        }
    }
}

