// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/billing/v1/cloud_billing.proto

package billingpb

import (
	context "context"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudBilling_GetBillingAccount_FullMethodName        = "/google.cloud.billing.v1.CloudBilling/GetBillingAccount"
	CloudBilling_ListBillingAccounts_FullMethodName      = "/google.cloud.billing.v1.CloudBilling/ListBillingAccounts"
	CloudBilling_UpdateBillingAccount_FullMethodName     = "/google.cloud.billing.v1.CloudBilling/UpdateBillingAccount"
	CloudBilling_CreateBillingAccount_FullMethodName     = "/google.cloud.billing.v1.CloudBilling/CreateBillingAccount"
	CloudBilling_ListProjectBillingInfo_FullMethodName   = "/google.cloud.billing.v1.CloudBilling/ListProjectBillingInfo"
	CloudBilling_GetProjectBillingInfo_FullMethodName    = "/google.cloud.billing.v1.CloudBilling/GetProjectBillingInfo"
	CloudBilling_UpdateProjectBillingInfo_FullMethodName = "/google.cloud.billing.v1.CloudBilling/UpdateProjectBillingInfo"
	CloudBilling_GetIamPolicy_FullMethodName             = "/google.cloud.billing.v1.CloudBilling/GetIamPolicy"
	CloudBilling_SetIamPolicy_FullMethodName             = "/google.cloud.billing.v1.CloudBilling/SetIamPolicy"
	CloudBilling_TestIamPermissions_FullMethodName       = "/google.cloud.billing.v1.CloudBilling/TestIamPermissions"
	CloudBilling_MoveBillingAccount_FullMethodName       = "/google.cloud.billing.v1.CloudBilling/MoveBillingAccount"
)

// CloudBillingClient is the client API for CloudBilling service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudBillingClient interface {
	// Gets information about a billing account. The current authenticated user
	// must be a [viewer of the billing
	// account](https://cloud.google.com/billing/docs/how-to/billing-access).
	GetBillingAccount(ctx context.Context, in *GetBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error)
	// Lists the billing accounts that the current authenticated user has
	// permission to
	// [view](https://cloud.google.com/billing/docs/how-to/billing-access).
	ListBillingAccounts(ctx context.Context, in *ListBillingAccountsRequest, opts ...grpc.CallOption) (*ListBillingAccountsResponse, error)
	// Updates a billing account's fields.
	// Currently the only field that can be edited is `display_name`.
	// The current authenticated user must have the `billing.accounts.update`
	// IAM permission, which is typically given to the
	// [administrator](https://cloud.google.com/billing/docs/how-to/billing-access)
	// of the billing account.
	UpdateBillingAccount(ctx context.Context, in *UpdateBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error)
	// This method creates [billing
	// subaccounts](https://cloud.google.com/billing/docs/concepts#subaccounts).
	//
	// Google Cloud resellers should use the
	// Channel Services APIs,
	// [accounts.customers.create](https://cloud.google.com/channel/docs/reference/rest/v1/accounts.customers/create)
	// and
	// [accounts.customers.entitlements.create](https://cloud.google.com/channel/docs/reference/rest/v1/accounts.customers.entitlements/create).
	//
	// When creating a subaccount, the current authenticated user must have the
	// `billing.accounts.update` IAM permission on the parent account, which is
	// typically given to billing account
	// [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
	// This method will return an error if the parent account has not been
	// provisioned for subaccounts.
	CreateBillingAccount(ctx context.Context, in *CreateBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error)
	// Lists the projects associated with a billing account. The current
	// authenticated user must have the `billing.resourceAssociations.list` IAM
	// permission, which is often given to billing account
	// [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
	ListProjectBillingInfo(ctx context.Context, in *ListProjectBillingInfoRequest, opts ...grpc.CallOption) (*ListProjectBillingInfoResponse, error)
	// Gets the billing information for a project. The current authenticated user
	// must have the `resourcemanager.projects.get` permission for the project,
	// which can be granted by assigning the [Project
	// Viewer](https://cloud.google.com/iam/docs/understanding-roles#predefined_roles)
	// role.
	GetProjectBillingInfo(ctx context.Context, in *GetProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error)
	// Sets or updates the billing account associated with a project. You specify
	// the new billing account by setting the `billing_account_name` in the
	// `ProjectBillingInfo` resource to the resource name of a billing account.
	// Associating a project with an open billing account enables billing on the
	// project and allows charges for resource usage. If the project already had a
	// billing account, this method changes the billing account used for resource
	// usage charges.
	//
	// *Note:* Incurred charges that have not yet been reported in the transaction
	// history of the Google Cloud Console might be billed to the new billing
	// account, even if the charge occurred before the new billing account was
	// assigned to the project.
	//
	// The current authenticated user must have ownership privileges for both
	// the
	// [project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ) and the [billing
	// account](https://cloud.google.com/billing/docs/how-to/billing-access).
	//
	// You can disable billing on the project by setting the
	// `billing_account_name` field to empty. This action disassociates the
	// current billing account from the project. Any billable activity of your
	// in-use services will stop, and your application could stop functioning as
	// expected. Any unbilled charges to date will be billed to the previously
	// associated account. The current authenticated user must be either an owner
	// of the project or an owner of the billing account for the project.
	//
	// Note that associating a project with a *closed* billing account will have
	// much the same effect as disabling billing on the project: any paid
	// resources used by the project will be shut down. Thus, unless you wish to
	// disable billing, you should always call this method with the name of an
	// *open* billing account.
	UpdateProjectBillingInfo(ctx context.Context, in *UpdateProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error)
	// Gets the access control policy for a billing account.
	// The caller must have the `billing.accounts.getIamPolicy` permission on the
	// account, which is often given to billing account
	// [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the access control policy for a billing account. Replaces any existing
	// policy.
	// The caller must have the `billing.accounts.setIamPolicy` permission on the
	// account, which is often given to billing account
	// [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Tests the access control policy for a billing account. This method takes
	// the resource and a set of permissions as input and returns the subset of
	// the input permissions that the caller is allowed for that resource.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Changes which parent organization a billing account belongs to.
	MoveBillingAccount(ctx context.Context, in *MoveBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error)
}

type cloudBillingClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudBillingClient(cc grpc.ClientConnInterface) CloudBillingClient {
	return &cloudBillingClient{cc}
}

func (c *cloudBillingClient) GetBillingAccount(ctx context.Context, in *GetBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error) {
	out := new(BillingAccount)
	err := c.cc.Invoke(ctx, CloudBilling_GetBillingAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) ListBillingAccounts(ctx context.Context, in *ListBillingAccountsRequest, opts ...grpc.CallOption) (*ListBillingAccountsResponse, error) {
	out := new(ListBillingAccountsResponse)
	err := c.cc.Invoke(ctx, CloudBilling_ListBillingAccounts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) UpdateBillingAccount(ctx context.Context, in *UpdateBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error) {
	out := new(BillingAccount)
	err := c.cc.Invoke(ctx, CloudBilling_UpdateBillingAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) CreateBillingAccount(ctx context.Context, in *CreateBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error) {
	out := new(BillingAccount)
	err := c.cc.Invoke(ctx, CloudBilling_CreateBillingAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) ListProjectBillingInfo(ctx context.Context, in *ListProjectBillingInfoRequest, opts ...grpc.CallOption) (*ListProjectBillingInfoResponse, error) {
	out := new(ListProjectBillingInfoResponse)
	err := c.cc.Invoke(ctx, CloudBilling_ListProjectBillingInfo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) GetProjectBillingInfo(ctx context.Context, in *GetProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error) {
	out := new(ProjectBillingInfo)
	err := c.cc.Invoke(ctx, CloudBilling_GetProjectBillingInfo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) UpdateProjectBillingInfo(ctx context.Context, in *UpdateProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error) {
	out := new(ProjectBillingInfo)
	err := c.cc.Invoke(ctx, CloudBilling_UpdateProjectBillingInfo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, CloudBilling_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, CloudBilling_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, CloudBilling_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) MoveBillingAccount(ctx context.Context, in *MoveBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error) {
	out := new(BillingAccount)
	err := c.cc.Invoke(ctx, CloudBilling_MoveBillingAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudBillingServer is the server API for CloudBilling service.
// All implementations should embed UnimplementedCloudBillingServer
// for forward compatibility
type CloudBillingServer interface {
	// Gets information about a billing account. The current authenticated user
	// must be a [viewer of the billing
	// account](https://cloud.google.com/billing/docs/how-to/billing-access).
	GetBillingAccount(context.Context, *GetBillingAccountRequest) (*BillingAccount, error)
	// Lists the billing accounts that the current authenticated user has
	// permission to
	// [view](https://cloud.google.com/billing/docs/how-to/billing-access).
	ListBillingAccounts(context.Context, *ListBillingAccountsRequest) (*ListBillingAccountsResponse, error)
	// Updates a billing account's fields.
	// Currently the only field that can be edited is `display_name`.
	// The current authenticated user must have the `billing.accounts.update`
	// IAM permission, which is typically given to the
	// [administrator](https://cloud.google.com/billing/docs/how-to/billing-access)
	// of the billing account.
	UpdateBillingAccount(context.Context, *UpdateBillingAccountRequest) (*BillingAccount, error)
	// This method creates [billing
	// subaccounts](https://cloud.google.com/billing/docs/concepts#subaccounts).
	//
	// Google Cloud resellers should use the
	// Channel Services APIs,
	// [accounts.customers.create](https://cloud.google.com/channel/docs/reference/rest/v1/accounts.customers/create)
	// and
	// [accounts.customers.entitlements.create](https://cloud.google.com/channel/docs/reference/rest/v1/accounts.customers.entitlements/create).
	//
	// When creating a subaccount, the current authenticated user must have the
	// `billing.accounts.update` IAM permission on the parent account, which is
	// typically given to billing account
	// [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
	// This method will return an error if the parent account has not been
	// provisioned for subaccounts.
	CreateBillingAccount(context.Context, *CreateBillingAccountRequest) (*BillingAccount, error)
	// Lists the projects associated with a billing account. The current
	// authenticated user must have the `billing.resourceAssociations.list` IAM
	// permission, which is often given to billing account
	// [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
	ListProjectBillingInfo(context.Context, *ListProjectBillingInfoRequest) (*ListProjectBillingInfoResponse, error)
	// Gets the billing information for a project. The current authenticated user
	// must have the `resourcemanager.projects.get` permission for the project,
	// which can be granted by assigning the [Project
	// Viewer](https://cloud.google.com/iam/docs/understanding-roles#predefined_roles)
	// role.
	GetProjectBillingInfo(context.Context, *GetProjectBillingInfoRequest) (*ProjectBillingInfo, error)
	// Sets or updates the billing account associated with a project. You specify
	// the new billing account by setting the `billing_account_name` in the
	// `ProjectBillingInfo` resource to the resource name of a billing account.
	// Associating a project with an open billing account enables billing on the
	// project and allows charges for resource usage. If the project already had a
	// billing account, this method changes the billing account used for resource
	// usage charges.
	//
	// *Note:* Incurred charges that have not yet been reported in the transaction
	// history of the Google Cloud Console might be billed to the new billing
	// account, even if the charge occurred before the new billing account was
	// assigned to the project.
	//
	// The current authenticated user must have ownership privileges for both
	// the
	// [project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ) and the [billing
	// account](https://cloud.google.com/billing/docs/how-to/billing-access).
	//
	// You can disable billing on the project by setting the
	// `billing_account_name` field to empty. This action disassociates the
	// current billing account from the project. Any billable activity of your
	// in-use services will stop, and your application could stop functioning as
	// expected. Any unbilled charges to date will be billed to the previously
	// associated account. The current authenticated user must be either an owner
	// of the project or an owner of the billing account for the project.
	//
	// Note that associating a project with a *closed* billing account will have
	// much the same effect as disabling billing on the project: any paid
	// resources used by the project will be shut down. Thus, unless you wish to
	// disable billing, you should always call this method with the name of an
	// *open* billing account.
	UpdateProjectBillingInfo(context.Context, *UpdateProjectBillingInfoRequest) (*ProjectBillingInfo, error)
	// Gets the access control policy for a billing account.
	// The caller must have the `billing.accounts.getIamPolicy` permission on the
	// account, which is often given to billing account
	// [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the access control policy for a billing account. Replaces any existing
	// policy.
	// The caller must have the `billing.accounts.setIamPolicy` permission on the
	// account, which is often given to billing account
	// [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Tests the access control policy for a billing account. This method takes
	// the resource and a set of permissions as input and returns the subset of
	// the input permissions that the caller is allowed for that resource.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Changes which parent organization a billing account belongs to.
	MoveBillingAccount(context.Context, *MoveBillingAccountRequest) (*BillingAccount, error)
}

// UnimplementedCloudBillingServer should be embedded to have forward compatible implementations.
type UnimplementedCloudBillingServer struct {
}

func (UnimplementedCloudBillingServer) GetBillingAccount(context.Context, *GetBillingAccountRequest) (*BillingAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBillingAccount not implemented")
}
func (UnimplementedCloudBillingServer) ListBillingAccounts(context.Context, *ListBillingAccountsRequest) (*ListBillingAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBillingAccounts not implemented")
}
func (UnimplementedCloudBillingServer) UpdateBillingAccount(context.Context, *UpdateBillingAccountRequest) (*BillingAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBillingAccount not implemented")
}
func (UnimplementedCloudBillingServer) CreateBillingAccount(context.Context, *CreateBillingAccountRequest) (*BillingAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBillingAccount not implemented")
}
func (UnimplementedCloudBillingServer) ListProjectBillingInfo(context.Context, *ListProjectBillingInfoRequest) (*ListProjectBillingInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProjectBillingInfo not implemented")
}
func (UnimplementedCloudBillingServer) GetProjectBillingInfo(context.Context, *GetProjectBillingInfoRequest) (*ProjectBillingInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProjectBillingInfo not implemented")
}
func (UnimplementedCloudBillingServer) UpdateProjectBillingInfo(context.Context, *UpdateProjectBillingInfoRequest) (*ProjectBillingInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProjectBillingInfo not implemented")
}
func (UnimplementedCloudBillingServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedCloudBillingServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedCloudBillingServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedCloudBillingServer) MoveBillingAccount(context.Context, *MoveBillingAccountRequest) (*BillingAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveBillingAccount not implemented")
}

// UnsafeCloudBillingServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudBillingServer will
// result in compilation errors.
type UnsafeCloudBillingServer interface {
	mustEmbedUnimplementedCloudBillingServer()
}

func RegisterCloudBillingServer(s grpc.ServiceRegistrar, srv CloudBillingServer) {
	s.RegisterService(&CloudBilling_ServiceDesc, srv)
}

func _CloudBilling_GetBillingAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBillingAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).GetBillingAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_GetBillingAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).GetBillingAccount(ctx, req.(*GetBillingAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_ListBillingAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBillingAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).ListBillingAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_ListBillingAccounts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).ListBillingAccounts(ctx, req.(*ListBillingAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_UpdateBillingAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBillingAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).UpdateBillingAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_UpdateBillingAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).UpdateBillingAccount(ctx, req.(*UpdateBillingAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_CreateBillingAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBillingAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).CreateBillingAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_CreateBillingAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).CreateBillingAccount(ctx, req.(*CreateBillingAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_ListProjectBillingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProjectBillingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).ListProjectBillingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_ListProjectBillingInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).ListProjectBillingInfo(ctx, req.(*ListProjectBillingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_GetProjectBillingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectBillingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).GetProjectBillingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_GetProjectBillingInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).GetProjectBillingInfo(ctx, req.(*GetProjectBillingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_UpdateProjectBillingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProjectBillingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).UpdateProjectBillingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_UpdateProjectBillingInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).UpdateProjectBillingInfo(ctx, req.(*UpdateProjectBillingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_MoveBillingAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveBillingAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).MoveBillingAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudBilling_MoveBillingAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).MoveBillingAccount(ctx, req.(*MoveBillingAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudBilling_ServiceDesc is the grpc.ServiceDesc for CloudBilling service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudBilling_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.billing.v1.CloudBilling",
	HandlerType: (*CloudBillingServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBillingAccount",
			Handler:    _CloudBilling_GetBillingAccount_Handler,
		},
		{
			MethodName: "ListBillingAccounts",
			Handler:    _CloudBilling_ListBillingAccounts_Handler,
		},
		{
			MethodName: "UpdateBillingAccount",
			Handler:    _CloudBilling_UpdateBillingAccount_Handler,
		},
		{
			MethodName: "CreateBillingAccount",
			Handler:    _CloudBilling_CreateBillingAccount_Handler,
		},
		{
			MethodName: "ListProjectBillingInfo",
			Handler:    _CloudBilling_ListProjectBillingInfo_Handler,
		},
		{
			MethodName: "GetProjectBillingInfo",
			Handler:    _CloudBilling_GetProjectBillingInfo_Handler,
		},
		{
			MethodName: "UpdateProjectBillingInfo",
			Handler:    _CloudBilling_UpdateProjectBillingInfo_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _CloudBilling_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _CloudBilling_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _CloudBilling_TestIamPermissions_Handler,
		},
		{
			MethodName: "MoveBillingAccount",
			Handler:    _CloudBilling_MoveBillingAccount_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/billing/v1/cloud_billing.proto",
}
