// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/securitycenter/settings/v1beta1/securitycenter_settings_service.proto

package settingspb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SecurityCenterSettingsService_GetServiceAccount_FullMethodName                   = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/GetServiceAccount"
	SecurityCenterSettingsService_GetSettings_FullMethodName                         = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/GetSettings"
	SecurityCenterSettingsService_UpdateSettings_FullMethodName                      = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/UpdateSettings"
	SecurityCenterSettingsService_ResetSettings_FullMethodName                       = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ResetSettings"
	SecurityCenterSettingsService_BatchGetSettings_FullMethodName                    = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/BatchGetSettings"
	SecurityCenterSettingsService_CalculateEffectiveSettings_FullMethodName          = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/CalculateEffectiveSettings"
	SecurityCenterSettingsService_BatchCalculateEffectiveSettings_FullMethodName     = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/BatchCalculateEffectiveSettings"
	SecurityCenterSettingsService_GetComponentSettings_FullMethodName                = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/GetComponentSettings"
	SecurityCenterSettingsService_UpdateComponentSettings_FullMethodName             = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/UpdateComponentSettings"
	SecurityCenterSettingsService_ResetComponentSettings_FullMethodName              = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ResetComponentSettings"
	SecurityCenterSettingsService_CalculateEffectiveComponentSettings_FullMethodName = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/CalculateEffectiveComponentSettings"
	SecurityCenterSettingsService_ListDetectors_FullMethodName                       = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ListDetectors"
	SecurityCenterSettingsService_ListComponents_FullMethodName                      = "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ListComponents"
)

// SecurityCenterSettingsServiceClient is the client API for SecurityCenterSettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SecurityCenterSettingsServiceClient interface {
	// Retrieves the organizations service account, if it exists, otherwise it
	// creates the organization service account. This API is idempotent and
	// will only create a service account once. On subsequent calls it will
	// return the previously created service account.  SHA, SCC and CTD Infra
	// Automation will use this SA.  This SA will not have any permissions when
	// created.  The UI will provision this via IAM or the user will using
	// their own internal process. This API only creates SAs on the organization.
	// Folders are not supported and projects will use per-project SAs associated
	// with APIs enabled on a project. This API will be called by the UX
	// onboarding workflow.
	GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Gets the Settings.
	GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Updates the Settings.
	UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Reset the organization, folder or project's settings and return
	// the settings of just that resource to the default.
	//
	// Settings are present at the organization, folder, project, and cluster
	// levels. Using Reset on a sub-organization level will remove that resource's
	// override and result in the parent's settings being used (eg: if Reset on a
	// cluster, project settings will be used).
	//
	// Using Reset on organization will remove the override that was set and
	// result in default settings being used.
	ResetSettings(ctx context.Context, in *ResetSettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a list of settings.
	BatchGetSettings(ctx context.Context, in *BatchGetSettingsRequest, opts ...grpc.CallOption) (*BatchGetSettingsResponse, error)
	// CalculateEffectiveSettings looks up all of the Security Center
	// Settings resources in the GCP resource hierarchy, and calculates the
	// effective settings on that resource by applying the following rules:
	//   - Settings provided closer to the target resource take precedence over
	//     those further away (e.g. folder will override organization level
	//     settings).
	//   - Product defaults can be overridden at org, folder, project, and cluster
	//     levels.
	//   - Detectors will be filtered out if they belong to a billing tier the
	//     customer
	//     has not configured.
	CalculateEffectiveSettings(ctx context.Context, in *CalculateEffectiveSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Gets a list of effective settings.
	BatchCalculateEffectiveSettings(ctx context.Context, in *BatchCalculateEffectiveSettingsRequest, opts ...grpc.CallOption) (*BatchCalculateEffectiveSettingsResponse, error)
	// Gets the Component Settings.
	GetComponentSettings(ctx context.Context, in *GetComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error)
	// Updates the Component Settings.
	UpdateComponentSettings(ctx context.Context, in *UpdateComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error)
	// Reset the organization, folder or project's component settings and return
	// the settings to the default. Settings are present at the
	// organization, folder and project levels. Using Reset for a folder or
	// project will remove the override that was set and result in the
	// organization-level settings being used.
	ResetComponentSettings(ctx context.Context, in *ResetComponentSettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the Effective Component Settings.
	CalculateEffectiveComponentSettings(ctx context.Context, in *CalculateEffectiveComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error)
	// Retrieves an unordered list of available detectors.
	ListDetectors(ctx context.Context, in *ListDetectorsRequest, opts ...grpc.CallOption) (*ListDetectorsResponse, error)
	// Retrieves an unordered list of available SCC components.
	ListComponents(ctx context.Context, in *ListComponentsRequest, opts ...grpc.CallOption) (*ListComponentsResponse, error)
}

type securityCenterSettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSecurityCenterSettingsServiceClient(cc grpc.ClientConnInterface) SecurityCenterSettingsServiceClient {
	return &securityCenterSettingsServiceClient{cc}
}

func (c *securityCenterSettingsServiceClient) GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_GetServiceAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_GetSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_UpdateSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) ResetSettings(ctx context.Context, in *ResetSettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_ResetSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) BatchGetSettings(ctx context.Context, in *BatchGetSettingsRequest, opts ...grpc.CallOption) (*BatchGetSettingsResponse, error) {
	out := new(BatchGetSettingsResponse)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_BatchGetSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) CalculateEffectiveSettings(ctx context.Context, in *CalculateEffectiveSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_CalculateEffectiveSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) BatchCalculateEffectiveSettings(ctx context.Context, in *BatchCalculateEffectiveSettingsRequest, opts ...grpc.CallOption) (*BatchCalculateEffectiveSettingsResponse, error) {
	out := new(BatchCalculateEffectiveSettingsResponse)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_BatchCalculateEffectiveSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) GetComponentSettings(ctx context.Context, in *GetComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error) {
	out := new(ComponentSettings)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_GetComponentSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) UpdateComponentSettings(ctx context.Context, in *UpdateComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error) {
	out := new(ComponentSettings)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_UpdateComponentSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) ResetComponentSettings(ctx context.Context, in *ResetComponentSettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_ResetComponentSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) CalculateEffectiveComponentSettings(ctx context.Context, in *CalculateEffectiveComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error) {
	out := new(ComponentSettings)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_CalculateEffectiveComponentSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) ListDetectors(ctx context.Context, in *ListDetectorsRequest, opts ...grpc.CallOption) (*ListDetectorsResponse, error) {
	out := new(ListDetectorsResponse)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_ListDetectors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) ListComponents(ctx context.Context, in *ListComponentsRequest, opts ...grpc.CallOption) (*ListComponentsResponse, error) {
	out := new(ListComponentsResponse)
	err := c.cc.Invoke(ctx, SecurityCenterSettingsService_ListComponents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterSettingsServiceServer is the server API for SecurityCenterSettingsService service.
// All implementations should embed UnimplementedSecurityCenterSettingsServiceServer
// for forward compatibility
type SecurityCenterSettingsServiceServer interface {
	// Retrieves the organizations service account, if it exists, otherwise it
	// creates the organization service account. This API is idempotent and
	// will only create a service account once. On subsequent calls it will
	// return the previously created service account.  SHA, SCC and CTD Infra
	// Automation will use this SA.  This SA will not have any permissions when
	// created.  The UI will provision this via IAM or the user will using
	// their own internal process. This API only creates SAs on the organization.
	// Folders are not supported and projects will use per-project SAs associated
	// with APIs enabled on a project. This API will be called by the UX
	// onboarding workflow.
	GetServiceAccount(context.Context, *GetServiceAccountRequest) (*ServiceAccount, error)
	// Gets the Settings.
	GetSettings(context.Context, *GetSettingsRequest) (*Settings, error)
	// Updates the Settings.
	UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error)
	// Reset the organization, folder or project's settings and return
	// the settings of just that resource to the default.
	//
	// Settings are present at the organization, folder, project, and cluster
	// levels. Using Reset on a sub-organization level will remove that resource's
	// override and result in the parent's settings being used (eg: if Reset on a
	// cluster, project settings will be used).
	//
	// Using Reset on organization will remove the override that was set and
	// result in default settings being used.
	ResetSettings(context.Context, *ResetSettingsRequest) (*emptypb.Empty, error)
	// Gets a list of settings.
	BatchGetSettings(context.Context, *BatchGetSettingsRequest) (*BatchGetSettingsResponse, error)
	// CalculateEffectiveSettings looks up all of the Security Center
	// Settings resources in the GCP resource hierarchy, and calculates the
	// effective settings on that resource by applying the following rules:
	//   - Settings provided closer to the target resource take precedence over
	//     those further away (e.g. folder will override organization level
	//     settings).
	//   - Product defaults can be overridden at org, folder, project, and cluster
	//     levels.
	//   - Detectors will be filtered out if they belong to a billing tier the
	//     customer
	//     has not configured.
	CalculateEffectiveSettings(context.Context, *CalculateEffectiveSettingsRequest) (*Settings, error)
	// Gets a list of effective settings.
	BatchCalculateEffectiveSettings(context.Context, *BatchCalculateEffectiveSettingsRequest) (*BatchCalculateEffectiveSettingsResponse, error)
	// Gets the Component Settings.
	GetComponentSettings(context.Context, *GetComponentSettingsRequest) (*ComponentSettings, error)
	// Updates the Component Settings.
	UpdateComponentSettings(context.Context, *UpdateComponentSettingsRequest) (*ComponentSettings, error)
	// Reset the organization, folder or project's component settings and return
	// the settings to the default. Settings are present at the
	// organization, folder and project levels. Using Reset for a folder or
	// project will remove the override that was set and result in the
	// organization-level settings being used.
	ResetComponentSettings(context.Context, *ResetComponentSettingsRequest) (*emptypb.Empty, error)
	// Gets the Effective Component Settings.
	CalculateEffectiveComponentSettings(context.Context, *CalculateEffectiveComponentSettingsRequest) (*ComponentSettings, error)
	// Retrieves an unordered list of available detectors.
	ListDetectors(context.Context, *ListDetectorsRequest) (*ListDetectorsResponse, error)
	// Retrieves an unordered list of available SCC components.
	ListComponents(context.Context, *ListComponentsRequest) (*ListComponentsResponse, error)
}

// UnimplementedSecurityCenterSettingsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedSecurityCenterSettingsServiceServer struct {
}

func (UnimplementedSecurityCenterSettingsServiceServer) GetServiceAccount(context.Context, *GetServiceAccountRequest) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceAccount not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) GetSettings(context.Context, *GetSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) ResetSettings(context.Context, *ResetSettingsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) BatchGetSettings(context.Context, *BatchGetSettingsRequest) (*BatchGetSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) CalculateEffectiveSettings(context.Context, *CalculateEffectiveSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateEffectiveSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) BatchCalculateEffectiveSettings(context.Context, *BatchCalculateEffectiveSettingsRequest) (*BatchCalculateEffectiveSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCalculateEffectiveSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) GetComponentSettings(context.Context, *GetComponentSettingsRequest) (*ComponentSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetComponentSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) UpdateComponentSettings(context.Context, *UpdateComponentSettingsRequest) (*ComponentSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateComponentSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) ResetComponentSettings(context.Context, *ResetComponentSettingsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetComponentSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) CalculateEffectiveComponentSettings(context.Context, *CalculateEffectiveComponentSettingsRequest) (*ComponentSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateEffectiveComponentSettings not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) ListDetectors(context.Context, *ListDetectorsRequest) (*ListDetectorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDetectors not implemented")
}
func (UnimplementedSecurityCenterSettingsServiceServer) ListComponents(context.Context, *ListComponentsRequest) (*ListComponentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListComponents not implemented")
}

// UnsafeSecurityCenterSettingsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SecurityCenterSettingsServiceServer will
// result in compilation errors.
type UnsafeSecurityCenterSettingsServiceServer interface {
	mustEmbedUnimplementedSecurityCenterSettingsServiceServer()
}

func RegisterSecurityCenterSettingsServiceServer(s grpc.ServiceRegistrar, srv SecurityCenterSettingsServiceServer) {
	s.RegisterService(&SecurityCenterSettingsService_ServiceDesc, srv)
}

func _SecurityCenterSettingsService_GetServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).GetServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_GetServiceAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).GetServiceAccount(ctx, req.(*GetServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_GetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).GetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_GetSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).GetSettings(ctx, req.(*GetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_UpdateSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).UpdateSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_UpdateSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).UpdateSettings(ctx, req.(*UpdateSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_ResetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).ResetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_ResetSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).ResetSettings(ctx, req.(*ResetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_BatchGetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).BatchGetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_BatchGetSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).BatchGetSettings(ctx, req.(*BatchGetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_CalculateEffectiveSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateEffectiveSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).CalculateEffectiveSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_CalculateEffectiveSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).CalculateEffectiveSettings(ctx, req.(*CalculateEffectiveSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_BatchCalculateEffectiveSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCalculateEffectiveSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).BatchCalculateEffectiveSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_BatchCalculateEffectiveSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).BatchCalculateEffectiveSettings(ctx, req.(*BatchCalculateEffectiveSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_GetComponentSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetComponentSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).GetComponentSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_GetComponentSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).GetComponentSettings(ctx, req.(*GetComponentSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_UpdateComponentSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateComponentSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).UpdateComponentSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_UpdateComponentSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).UpdateComponentSettings(ctx, req.(*UpdateComponentSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_ResetComponentSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetComponentSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).ResetComponentSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_ResetComponentSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).ResetComponentSettings(ctx, req.(*ResetComponentSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_CalculateEffectiveComponentSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateEffectiveComponentSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).CalculateEffectiveComponentSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_CalculateEffectiveComponentSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).CalculateEffectiveComponentSettings(ctx, req.(*CalculateEffectiveComponentSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_ListDetectors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDetectorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).ListDetectors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_ListDetectors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).ListDetectors(ctx, req.(*ListDetectorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_ListComponents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListComponentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).ListComponents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenterSettingsService_ListComponents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).ListComponents(ctx, req.(*ListComponentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SecurityCenterSettingsService_ServiceDesc is the grpc.ServiceDesc for SecurityCenterSettingsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SecurityCenterSettingsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService",
	HandlerType: (*SecurityCenterSettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetServiceAccount",
			Handler:    _SecurityCenterSettingsService_GetServiceAccount_Handler,
		},
		{
			MethodName: "GetSettings",
			Handler:    _SecurityCenterSettingsService_GetSettings_Handler,
		},
		{
			MethodName: "UpdateSettings",
			Handler:    _SecurityCenterSettingsService_UpdateSettings_Handler,
		},
		{
			MethodName: "ResetSettings",
			Handler:    _SecurityCenterSettingsService_ResetSettings_Handler,
		},
		{
			MethodName: "BatchGetSettings",
			Handler:    _SecurityCenterSettingsService_BatchGetSettings_Handler,
		},
		{
			MethodName: "CalculateEffectiveSettings",
			Handler:    _SecurityCenterSettingsService_CalculateEffectiveSettings_Handler,
		},
		{
			MethodName: "BatchCalculateEffectiveSettings",
			Handler:    _SecurityCenterSettingsService_BatchCalculateEffectiveSettings_Handler,
		},
		{
			MethodName: "GetComponentSettings",
			Handler:    _SecurityCenterSettingsService_GetComponentSettings_Handler,
		},
		{
			MethodName: "UpdateComponentSettings",
			Handler:    _SecurityCenterSettingsService_UpdateComponentSettings_Handler,
		},
		{
			MethodName: "ResetComponentSettings",
			Handler:    _SecurityCenterSettingsService_ResetComponentSettings_Handler,
		},
		{
			MethodName: "CalculateEffectiveComponentSettings",
			Handler:    _SecurityCenterSettingsService_CalculateEffectiveComponentSettings_Handler,
		},
		{
			MethodName: "ListDetectors",
			Handler:    _SecurityCenterSettingsService_ListDetectors_Handler,
		},
		{
			MethodName: "ListComponents",
			Handler:    _SecurityCenterSettingsService_ListComponents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycenter/settings/v1beta1/securitycenter_settings_service.proto",
}
