---
title: glab deploy-key add
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

Add a deploy key to a GitLab project.

## Synopsis

Creates a new deploy key.

Requires the '--title' flag.

```plaintext
glab deploy-key add [key-file] [flags]
```

## Examples

```console
# Read deploy key from stdin and upload.
$ glab deploy-key add -t "my title"

# Read deploy key from specified key file and upload
$ cat ~/.ssh/id_ed25519.pub | glab deploy-key add --title='test' -

# Read deploy key from specified key file, upload and set "can push" attribute.
$ glab deploy-key add ~/.ssh/id_ed25519.pub -t "my title" --can-push true

```

## Options

```plaintext
  -c, --can-push            If true, deploy keys can be used for pushing code to the repository.
  -e, --expires-at string   The expiration date of the deploy key, using the ISO-8601 format: YYYY-MM-DDTHH:MM:SSZ.
  -t, --title string        New deploy key's title.
```

## Options inherited from parent commands

```plaintext
  -h, --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
