/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.coderegion.CodeRegionResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.ui.LiveResultsPanel;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;

public class CodeRegionLivePanel
extends JPanel
implements LiveResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.cpu.Bundle");
    private static final String PANEL_NAME = messages.getString("CodeRegionLivePanel_PanelName");
    private static final String NO_RESULTS_TERMINATED_MSG = messages.getString("CodeRegionLivePanel_NoResultsTerminatedMsg");
    private static final String NO_RESULTS_REGION_MSG = messages.getString("CodeRegionLivePanel_NoResultsRegionMsg");
    private static final String INDIVIDUAL_TIMES_MSG = messages.getString("CodeRegionLivePanel_IndividualTimesMsg");
    private static final String SUMMARY_TIMES_MSG = messages.getString("CodeRegionLivePanel_SummaryTimesMsg");
    private static final String TOTAL_INVOCATIONS_MSG = messages.getString("CodeRegionLivePanel_TotalInvocationsMsg");
    private static final String ALL_REMEMBERED_MSG = messages.getString("CodeRegionLivePanel_AllRememberedMsg");
    private static final String LAST_REMEMBERED_MSG = messages.getString("CodeRegionLivePanel_LastRememberedMsg");
    private static final String INVOCATIONS_LISTED_MSG = messages.getString("CodeRegionLivePanel_InvocationsListedMsg");
    private static final String AREA_ACCESS_NAME = messages.getString("CodeRegionLivePanel_AreaAccessName");
    private HTMLTextArea resArea;
    private ProfilerClient profilerClient;

    public CodeRegionLivePanel(ProfilerClient client) {
        this.profilerClient = client;
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout());
        this.resArea = new HTMLTextArea();
        this.resArea.getAccessibleContext().setAccessibleName(AREA_ACCESS_NAME);
        this.add((Component)new JScrollPane(this.resArea), "Center");
    }

    @Override
    public int getSortingColumn() {
        return -1;
    }

    @Override
    public boolean getSortingOrder() {
        return false;
    }

    public String getTitle() {
        return PANEL_NAME;
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        return null;
    }

    @Override
    public String getViewName() {
        return null;
    }

    @Override
    public boolean fitsVisibleArea() {
        return true;
    }

    @Override
    public void handleRemove() {
    }

    @Override
    public void handleShutdown() {
    }

    @Override
    public boolean hasView() {
        return false;
    }

    @Override
    public void reset() {
        this.updateLiveResults();
    }

    @Override
    public boolean supports(int instrumentationType) {
        return instrumentationType == 1;
    }

    @Override
    public void updateLiveResults() {
        try {
            CodeRegionResultsSnapshot sn = this.profilerClient.getCodeRegionProfilingResultsSnapshot();
            this.resArea.setText(this.getResultsText(sn.getTimes(), sn.getTimerCountsInSecond()));
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            this.resArea.setText("<i>" + NO_RESULTS_TERMINATED_MSG + "</i>");
        }
    }

    private String getResultsText(long[] results, long timerCountsInSecond) {
        StringBuilder resultText = new StringBuilder(results.length * 10);
        StringBuilder summaryOfTimes = new StringBuilder();
        long sum = 0L;
        if (results.length < 2) {
            resultText.append("<i>").append(NO_RESULTS_REGION_MSG).append("</i>");
        } else {
            long max;
            long min = max = results[1];
            int nRes = results.length - 1;
            StringBuilder individualTimes = new StringBuilder();
            for (int i = 1; i < results.length; ++i) {
                long time = results[i];
                sum += time;
                if (time > max) {
                    max = time;
                } else if (time < min) {
                    min = time;
                }
                individualTimes.append(MessageFormat.format(INDIVIDUAL_TIMES_MSG, StringUtils.mcsTimeToString((long)(time * 1000000L / timerCountsInSecond))));
                individualTimes.append("<br>");
            }
            summaryOfTimes.append(MessageFormat.format(SUMMARY_TIMES_MSG, StringUtils.mcsTimeToString((long)(sum * 1000000L / timerCountsInSecond)), StringUtils.mcsTimeToString((long)((long)((double)sum * 1000000.0 / (double)nRes / (double)timerCountsInSecond))), StringUtils.mcsTimeToString((long)(min * 1000000L / timerCountsInSecond)), StringUtils.mcsTimeToString((long)(max * 1000000L / timerCountsInSecond))));
            resultText.append(MessageFormat.format(TOTAL_INVOCATIONS_MSG, "" + results[0]));
            resultText.append(", ");
            if (results[0] <= (long)nRes) {
                resultText.append(ALL_REMEMBERED_MSG);
            } else {
                resultText.append(MessageFormat.format(LAST_REMEMBERED_MSG, "" + nRes));
            }
            resultText.append("<br>");
            resultText.append((CharSequence)summaryOfTimes);
            resultText.append("<br><br><hr><br>");
            resultText.append((CharSequence)individualTimes);
            resultText.append("<br><hr><br>");
            resultText.append(MessageFormat.format(INVOCATIONS_LISTED_MSG, "" + nRes));
            resultText.append(", ");
            resultText.append((CharSequence)summaryOfTimes);
        }
        return resultText.toString();
    }
}

